// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ modelManager.h ]		Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _MODELMANAGER_H_
#define _MODELMANAGER_H_

#include "main.h"
#include <unordered_map>

// ======== ======== ======== ======== ======== ======== ======== ========
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CModelManager
{
public:
	typedef struct
	{
		LPD3DXMESH pMesh;			// bVC^[tFCX|C^
		LPD3DXBUFFER pBuffMat;		// }eA
		DWORD numMat;				// }eA
		D3DXMATERIAL* pMat;			// 
	}MODEL;

	CModelManager(){}
	~CModelManager(){}

	void Init(void);
	void Uninit(void);
	
	bool SetModel(const std::string &strFilePass);

	LPD3DXMESH GetModelMesh(const std::string &strFilePass);
	LPD3DXBUFFER GetModelBuffMat(const std::string &strFilePass);
	DWORD GetModelNumMat(const std::string &strFilePass);
	D3DXMATERIAL *GetModelMat(const std::string &strFilePass);
	
	bool Release(const std::string &strFilePass);			// 
	void ReleaseAll(void);									// SJ

private:
	std::unordered_map<std::string, MODEL*> m_umapModel;	// t@CpX
};

#endif